﻿<?php
	
	$language = $_GET['lang'];
	$type = $_GET['type'];
	include('language/'.$language.'.php');

	require_once 'include/class.user.php';

	$user_home = new USER();
	
	if ($type=="leaderboard") {
		$leaderboardScores = [];
		$leaderboardScores["scores"] = [];

		$sql1 = "SELECT id, name, token, reverse FROM leaderboards WHERE id = ?";

		if ($stmt = $user_home->prepareQuery($sql1)) {
			$stmt->bind_param('i', $_GET['id']);
			$stmt->execute();

			$stmt->store_result();
			$stmt->bind_result($leaderboardID, $leaderboardName, $leaderboardToken, $leaderboardReverse);
			$stmt->fetch();

			if ($stmt->num_rows == 1) {
				$leaderboardScores["name"] = $leaderboardName;
				$leaderboardScores["id"] = $leaderboardID;
			} else {

			}
			$stmt->free_result();
			switch($leaderboardReverse) {
				case 1:
					$reverse = 'ASC';
					break;
				case 0:
					$reverse = 'DESC';
					break;
			}
		}

		$sql2 = "SELECT score, user_id, name, add_datetime FROM {$leaderboardToken}_scores WHERE table_id=? ORDER BY score $reverse";
		if ($stmt = $user_home->prepareQuery($sql2)) {
			$stmt->bind_param('i', $_GET['id']);
			$stmt->execute();
			$stmt->bind_result($score, $userID, $name, $date);
			while ($stmt->fetch()) {
				$leaderboardScores["scores"][] = array("score" => $score, "userID" => $userID, "name" => $name, "date" => $date);
			}
		}
	} else if ($type=="achievement") {
		$achievementHits = [];
		$achievementHits["hits"] = [];

		$sql1 = "SELECT id, name, token FROM achievements WHERE id = ?";

		if ($stmt = $user_home->prepareQuery($sql1)) {
			$stmt->bind_param('i', $_GET['id']);
			$stmt->execute();

			$stmt->store_result();
			$stmt->bind_result($achievementID, $achievementName, $achievementToken);
			$stmt->fetch();

			if ($stmt->num_rows == 1) {
				$achievementHits["name"] = $achievementName;
				$achievementHits["id"] = $achievementID;
			} else {

			}
			$stmt->free_result();
		}

		$sql2 = "SELECT user_id, add_datetime FROM {$achievementToken}_hits WHERE achievement_id=? ORDER BY add_datetime DESC";
		if ($stmt = $user_home->prepareQuery($sql2)) {
			$stmt->bind_param('i', $_GET['id']);
			$stmt->execute();
			$stmt->bind_result($userID, $date);
			while ($stmt->fetch()) {
				$achievementHits["hits"][] = array("userID" => $userID, "date" => $date);
			}
		}
	}
?>
<!DOCTYPE html>
<html lang="<?= $language; ?>">

    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <link href="assets/css/bootstrap.css" rel="stylesheet">
        <link href="assets/css/style-<?= $language; ?>.css" rel="stylesheet">
        <script src="assets/js/jquery-3.2.1.min.js"></script>
        <script src="assets/js/ajax.js"></script>
    </head>

    <body>
        <table class="table table-bordered table-striped table-hover <?php if ($type=="leaderboard") {echo 'scores';} ?>" id="paginated">
            <thead class="thead-inverse">
                <tr>
					<?php if ($type=="leaderboard") { ?>
						<th><?= $lang['player_rank']; ?></th>
						<th><?= $lang['player_name']; ?></th>
						<th><?= $lang['score']; ?></th>
						<th><?= $lang['score_date']; ?></th>
					<?php } else if ($type=="achievement") { ?>
						<th><?= $lang['player_id']; ?></th>
						<th><?= $lang['score_date']; ?></th>
					<?php } ?>
                </tr>
            </thead>
            <tbody>
                <?php
					if ($type=="leaderboard") {
						if(count($leaderboardScores["scores"])==0) {
							echo '<tr><td colspan="4"><div class="alert alert-danger">'.$lang["no_score"].'</div></td></tr>';
						}
					} else if ($type=="achievement") {
						if(count($achievementHits["hits"])==0) {
							echo '<tr><td colspan="2"><div class="alert alert-danger">'.$lang["no_hit"].'</div></td></tr>';
						}
					}
				?>
				<?php if ($type=="leaderboard") { ?>
					<?php foreach ($leaderboardScores["scores"] as $score) : ?>
						<tr>
							<td colspan="1" id="no_score"></td>
							<td><?= $score["name"]; ?></td>
							<td><?= $score["score"]; ?></td>
							<td><?= $score["date"]; ?></td>
						</tr>
					<?php endforeach; ?>
				<?php } else if ($type=="achievement") { ?>
					<?php foreach ($achievementHits["hits"] as $hit) : ?>
						<tr>
							<td><?= $hit["userID"]; ?></td>
							<td><?= $hit["date"]; ?></td>
						</tr>
					<?php endforeach; ?>
				<?php } ?>
            </tbody>
        </table>
    </body>

</html>